//
//  standardMode.m
//  POSSDKForIOS 2013-07-25
//
//  Created by liangchenying on 12-4-9.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "standardMode.h"
#import "ButtonPullDownRealize.h"

@interface standardMode()
@property (nonatomic, retain) POSSDK	 *pos_sdk;
@end

@implementation standardMode
@synthesize Back;
@synthesize standardModePrintAreaX;
@synthesize standardModePrintAreaWidth;
@synthesize SelectButton;
@synthesize standardModeStartingPositionX;
@synthesize pos_sdk		    = _pos_sdk;

- (id)initWithNibNamePOSSDK:(NSString *)nibNameOrNil pos_sdk:(POSSDK*)pos_sdk bundle:(NSBundle *)nibBundleOrNil
{
    self.pos_sdk = pos_sdk;
    return [self initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self.standardModeStartingPositionX setDelegate:self];
    [self.standardModePrintAreaX        setDelegate:self];
    [self.standardModePrintAreaWidth    setDelegate:self];
    [self.standardModeStartingPositionX setText:@"0"];
    [self.standardModePrintAreaX        setText:@"0"];
    [self.standardModePrintAreaWidth    setText:@"640"];
}

- (void)viewDidUnload
{
    [self setBack:nil];
    [self setStandardModePrintAreaX:nil];
    [self setStandardModePrintAreaWidth:nil];
    [self setSelectButton:nil];
    [self setStandardModeStartingPositionX:nil];
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

//**************************************************************************************************
//Exit the keyboard by clicking "return"
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if ([string isEqualToString:@"\n"])
    {
        [self.standardModeStartingPositionX resignFirstResponder];
        [self.standardModePrintAreaX        resignFirstResponder];
        [self.standardModePrintAreaWidth    resignFirstResponder];
        
        return NO;
    }
return YES;
}

//**************************************************************************************************
//Return to the main View by press the button "Back"
- (IBAction)Back:(id)sender 
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

//**************************************************************************************************
//Select Standard Mode and Set Paramters
- (IBAction)Select:(id)sender
{
    SInt32 error_code          = SUCCESS;
	SInt32 starting_position_X = 0;
	SInt32 print_area_X        = 0;
	SInt32 print_area_Width    = 0;
    SInt32 i                   = 0;
    
     error_code = [self.pos_sdk systemReset];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }

    //**************************************************************************************************
    //If StartingPositionX == nil ,Set StartingPositionX = 0.
    JudgeParamNil(standardModeStartingPositionX, @"Starting PositionX == nil ! It must be 0-65535");
    
    //**************************************************************************************************
    //If AreaX == nil ,Set AreaX = 0.
    JudgeParamNil(standardModePrintAreaX, @"Print AreaX == nil ! It must be 0-65535");
    
    //**************************************************************************************************
    //If PrinterWidth == nil ,Set PrinterWidth =640.
    JudgeParamNil(standardModePrintAreaWidth, @"Print Area Width == nil ! It must be 0-65535");
    
    //**************************************************************************************************
    //Starting position must be digit.
	JudgeParamDigitOrNot(standardModeStartingPositionX, @"ERROR Starting PositionX ! It must be 0-65535");
    
    //**************************************************************************************************
    //Starting position must be 0-65535
	starting_position_X  = [self.standardModeStartingPositionX.text intValue];
    JudgeParamRange(starting_position_X, 0, 65535,  @"ERROR Starting PositionX ! It must be 0-65535");
    
	//**************************************************************************************************
    //Select Standard Mode
    error_code = [self.pos_sdk systemSelectPrintMode:PrintModeStandard];
    if(error_code != SUCCESS)
	{
		goto ExitLine;
	}
    
    //**************************************************************************************************
    //Set Starting PositionX 
	error_code = [self.pos_sdk standardModeSetStartingPosition:starting_position_X];
	if(error_code != SUCCESS)
	{
        AlertViewShow(@"ERROR Set Starting Position")
		goto ExitLine;
	}	
    
    //**************************************************************************************************
    //Print AreaX must be digit.
	JudgeParamDigitOrNot(standardModePrintAreaX, @"ERROR Print AreaX ! It must be 0-65535");
    //**************************************************************************************************
    //Print AreaX must be 0-65535
	print_area_X     = [self.standardModePrintAreaX.text intValue];
    JudgeParamRange(print_area_X, 0, 65535,  @"ERROR Print AreaX ! It must be 0-65535");
    
    //**************************************************************************************************
    //Print Area Width must be digit.
	JudgeParamDigitOrNot(standardModePrintAreaWidth, @"ERROR Print Area Width ! It must be 0-65535");
    //**************************************************************************************************
    //Print Area Width must be 0-65535
	print_area_Width = [self.standardModePrintAreaWidth.text intValue];
    JudgeParamRange(print_area_Width, 0, 65535,  @"ERROR Print Area Width ! It must be 0-65535");

    //**************************************************************************************************
    //Set print area in standard mode
	error_code     = [self.pos_sdk standardModeSetLeftMarginAndPrintAreaWidth:print_area_X Width:print_area_Width];
    if (error_code == SUCCESS) //Back to main view if SUCCESS 
    {
        AlertViewShow(@"SUCCESS!Please Press BackButton to back to mainview");
    }
    else
    {
        AlertViewShow(@"ERROR Set Parameters in standard mode");
    }
    
    ExitLine:
    return;
}

- (void)dealloc 
{
    [self.Back release];
    [self.standardModePrintAreaX release];
    [self.standardModePrintAreaWidth release];
    [self.SelectButton release];
    [self.standardModeStartingPositionX release];
    [super dealloc];
}

@end
